TITLE   'Field around a Wire'						{ exa121.pde }
SELECT     					{ Student Edition }
   errlim=3e-4     ngrid=1     spectral_colors	
VARIABLES   Az                   		{ Magnetic vector potential }
DEFINITIONS                      			{ SI units }
   r0=0.2     r1=1.0     rad=sqrt( x^2+y^2) 	{ Radius }
   mu0=4*pi*1e-7    mu=mu0     Jz0=1.0	{ Jz in wire }		
   Bex=dy(Az)     Bey=-dx(Az)
   B=vector( Bex, Bey)     Bm=magnitude( B)
   Hx=Bex/mu     Hy=Bey/mu     H=B/mu     Hm=Bm/mu	
   Jz     Bm_ex					{ Declared only }
EQUATIONS
   dx( Hy)- dy( Hx)=Jz
BOUNDARIES
region 'domain'  Jz=0          					
   Bm_ex=mu*Jz0*r0^2/(2*rad)	{ Exact solution, see text below }
   start 'outer' (-r1,0) value(Az)=0  arc(center=0,0) angle=360
region 'wire' Jz=Jz0
   Bm_ex=mu*Jz0*rad/2			
   start (-r0,0) arc( center=0,0) angle=360
PLOTS
   elevation( normal(B)/Bm) on 'outer'
   surface( Az)     contour( Bm)     contour( Bm_ex)
   vector( B) norm zoom(-2*r0,-2*r0,  4*r0,4*r0)
   contour( Bm-Bm_ex) report( globalmax( Bm))	
   elevation( Bm, Bm_ex) from (-r1,0) to (r1,0)
END


